package com.ejie.ab04b.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * ErrorField.
 * 
 * @author GFI
 */
public class ErrorField implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Nombre del campo o label del campo
	 */
	private String campo;
	/**
	 * Errores del campo
	 */
	private List<Mensaje> mensajes;

	/**
	 * Method 'ErrorField'.
	 * 
	 *  campo
	 *            campo
	 *  mensajes
	 *            mensajes
	 *
	 * @param campo the campo
	 * @param mensajes the mensajes
	 */
	public ErrorField(String campo, List<Mensaje> mensajes) {
		this.campo = campo;
		this.mensajes = mensajes;
	}

	/**
	 * Method 'ErrorField'.
	 * 
	 *  campo
	 *            campo
	 *  mensaje
	 *            Mensaje
	 *
	 * @param campo the campo
	 * @param mensaje the mensaje
	 */
	public ErrorField(String campo, Mensaje mensaje) {
		this.campo = campo;
		this.mensajes = new ArrayList<Mensaje>();
		this.mensajes.add(mensaje);
	}

	/**
	 * Method 'ErrorField'.
	 * 
	 *  campo
	 *            campo
	 *  mensaje
	 *            Mensaje
	 *
	 * @param campo the campo
	 * @param mensaje the mensaje
	 */
	public ErrorField(String campo, String mensaje) {
		this.campo = campo;
		this.mensajes = new ArrayList<Mensaje>();
		this.mensajes.add(new Mensaje(mensaje));
	}

	/**
	 * Method 'ErrorField'.
	 * 
	 *  campo
	 *            campo
	 *  mensaje
	 *            Mensaje
	 *  param
	 *            String
	 *
	 * @param campo the campo
	 * @param mensaje the mensaje
	 * @param param the param
	 */
	public ErrorField(String campo, String mensaje, String param) {
		this.campo = campo;
		this.mensajes = new ArrayList<Mensaje>();
		this.mensajes.add(new Mensaje(mensaje, param));
	}

	/**
	 * Method 'ErrorField'.
	 * 
	 *  campo
	 *            campo
	 *  mensaje
	 *            Mensaje
	 *  param
	 *            String
	 *  paramIsKey
	 *            boolean
	 *
	 * @param campo the campo
	 * @param mensaje the mensaje
	 * @param param the param
	 * @param paramIsKey the param is key
	 */
	public ErrorField(String campo, String mensaje, String param, boolean paramIsKey) {
		this.campo = campo;
		this.mensajes = new ArrayList<Mensaje>();
		this.mensajes.add(new Mensaje(mensaje, param, paramIsKey));
	}

	/**
	 * Method 'getCampo'.
	 * 
	 *  String
	 *
	 * @return the campo
	 */
	public String getCampo() {
		return this.campo;
	}

	/**
	 * Method 'setCampo'.
	 * 
	 *  campo
	 *            String
	 *
	 * @param campo the new campo
	 */
	public void setCampo(String campo) {
		this.campo = campo;
	}

	/**
	 * Method 'getMensajes'.
	 * 
	 *  List<Mensaje>
	 *
	 * @return the mensajes
	 */
	public List<Mensaje> getMensajes() {
		return this.mensajes;
	}

	/**
	 * Method 'setMensajes'.
	 * 
	 *  mensajes
	 *            List<Mensaje>
	 *
	 * @param mensajes the new mensajes
	 */
	public void setMensajes(List<Mensaje> mensajes) {
		this.mensajes = mensajes;
	}
}